unit CommonSRV03;
(* ================================================================

               
                 

   -----------------------------------------------------
    3.7. ()  , , , 2017..2020 .
               () Source code  ..
     12.01.2020
   ================================================================
*)
interface

uses //  
     SysUtils, MMSystem, Dialogs,
     //  
     CommonDEF03, CommonDAT03,
     //  .
     AppData00, AppData01, AppData02, AppData03,
     AppData04, AppData05, AppData06;

// ================================================================
//      
// ================================================================
// ---------------------
//    (RqPtApp) .
//     - 
function LoadAppLINKs(RqPtApp      : TPtApp;
                      RqPtAllConst : pointer;
                      RqMaxIndx    : integer;
                      RqPtArrDESC  : pointer) : boolean;
// ---------------------
//      
//  .  
function LoadAllPtScopeArr() : boolean;

// ================================================================
//            
// ================================================================
// ---------------------
//       RqAppInd
function TestPtApp(RqAppInd : integer) : TPtApp;
// ---------------------
//     .
function GetPtAllConst(RqPtApp   : TPtApp;
                 var  PtAllConst : TPtAllConst) : boolean;
// ---------------------
//       .
function GetScopeDESC(RqPtApp : TPtApp;
                      RqIndx  : integer;
                 var  DESC    : TAppScope ) : boolean;
// ---------------------
//       .
function GetScopeSOBJ(RqPtApp : TPtApp;
                     RqIndx   : integer;
                 var SOBJ     : TObject) : boolean;
// ---------------------
//      
//   .
function GetScopeDescSobj(RqPtApp : TPtApp;
                          RqIndx  : integer;
                     var  DESC    : TAppScope;
                     var  SOBJ    : TObject) : boolean;
// ================================================================
//      
// ================================================================
// ---------------------
//         
function LoadAllScopeAndSensorArr() : boolean;

// ================================================================
//       
// ================================================================
// ---------------------
//    
function StartMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
// ---------------------
//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;


// ================================================================
// ================================================================
implementation
// ================================================================
// ================================================================

// ================================================================
//      
// ================================================================
// ----------------------------------------------------------------
// 12.01.2020
//    (RqPtApp) .
//     - 
function LoadAppLINKs(RqPtApp      : TPtApp;
                     RqPtAllConst : pointer;
                     RqMaxIndx    : integer;
                     RqPtArrDESC  : pointer) : boolean;
var Indx : integer;
begin
   Result := False;
   if (RqMaxIndx < 0) or (RqMaxIndx > BufferMaxIndx) then Exit;
   with RqPtApp^ do
   begin
      try
         PtAllConst := TPtAllConst(RqPtAllConst);
         PtArrDESC  := RqPtArrDESC;
         MaxIndx    := RqMaxIndx;
         SetLength(ArrSOBJ, MaxIndx + 1);
         for Indx := Low(ArrSOBJ) to High(ArrSOBJ)
         do ArrSOBJ[Indx] := nil;
         Result := True;
      except end;
   end;
end;
// ----------------------------------------------------------------
//   !  LoadAllPtScopeArr()  
//       ,
// ----------------------------------------------------------------
// ----------------------------------------------------------------
// 12.01.2020
//      
//  .  
function LoadAllPtScopeArr() : boolean;
var Ind : integer;
begin
   Result := False;
   //   
   SetLength(AllPtScopeArr, AllAppCount);
   // ================================
   //   .
   // ================================
   // --------------------------------
   //   . App00
   if LoadAppLINKs(Addr(App00),
                   Addr(App00Const),
                   App00MaxIndx,
                   Addr(App00Scopes))
   then AllPtScopeArr[0] := Addr(App00)
   else AllPtScopeArr[0] := nil;
   // --------------------------------
   //   . App01
   if LoadAppLINKs(Addr(App01),
                   Addr(App01Const),
                   App01MaxIndx,
                   Addr(App01Scopes))
   then AllPtScopeArr[1] := Addr(App01)
   else AllPtScopeArr[1] := nil;
   // --------------------------------
   //   . App02
   if LoadAppLINKs(Addr(App02),
                   Addr(App02Const),
                   App02MaxIndx,
                   Addr(App02Scopes))
   then AllPtScopeArr[2] := Addr(App02)
   else AllPtScopeArr[2] := nil;
   // --------------------------------
   //   . App03
   if LoadAppLINKs(Addr(App03),
                   Addr(App03Const),
                   App03MaxIndx,
                   Addr(App03Scopes))
   then AllPtScopeArr[3] := Addr(App03)
   else AllPtScopeArr[3] := nil;
   // --------------------------------
   //   . App04
   if LoadAppLINKs(Addr(App04),
                   Addr(App04Const),
                   App04MaxIndx,
                   Addr(App04Scopes))
   then AllPtScopeArr[4] := Addr(App04)
   else AllPtScopeArr[4] := nil;
   // --------------------------------
   //   . App05
   if LoadAppLINKs(Addr(App05),
                   Addr(App05Const),
                   App05MaxIndx,
                   Addr(App05Scopes))
   then AllPtScopeArr[5] := Addr(App05)
   else AllPtScopeArr[5] := nil;
   // --------------------------------
   //   . App06
   if LoadAppLINKs(Addr(App06),
                   Addr(App06Const),
                   App06MaxIndx,
                   Addr(App06Scopes))
   then AllPtScopeArr[6] := Addr(App06)
   else AllPtScopeArr[6] := nil;
   // ================================
   //     
   //   
   for Ind := Low(AllPtScopeArr) to High(AllPtScopeArr)
   do if AllPtScopeArr[Ind] <> nil
      then begin
        Result := True;
        Exit;
      end;
end;
// ================================================================
//            
// ================================================================
// ----------------------------------------------------------------
// 11.01.2020
//    .   RqAppInd
function TestPtApp(RqAppInd : integer) : TPtApp;
begin
   Result := nil;
  // ----------------------------------
   //     RqAppInd
   if (RqAppInd <  Low(AllPtScopeArr)) or
      (RqAppInd > High(AllPtScopeArr))
   then Exit;
   // ----------------------------------
   //     
   Result := AllPtScopeArr[RqAppInd];
   if Result = nil
   then Exit;
   // ----------------------------------
   //    
   if (Result^.PtAllConst = nil) or
      (Result^.PtArrDESC  = nil) or
      (Length(Result^.ArrSOBJ) = 0)
   then Result := nil;
end;
// ----------------------------------------------------------------
// 12.01.2020
//       .
function GetScopeDESC(RqPtApp : TPtApp;
                      RqIndx  : integer;
                 var  DESC    : TAppScope) : boolean;
var wPtArrDESC : ^TMaxArrDESC;
begin
   Result := False;
   //    1
   if RqPtApp = nil then Exit;
   with RqPtApp^ do
   begin
      //    2
      if PtArrDESC = nil then Exit;
      if (RqIndx < 0) or (RqIndx > MaxIndx) then Exit;
      try
         wPtArrDESC := PtArrDESC;
         DESC := wPtArrDESC^[RqIndx];
         Result := True;
      except end;
   end;
end;
// ----------------------------------------------------------------
// 12.01.2020
//     .
function GetPtAllConst(RqPtApp   : TPtApp;
                 var  PtAllConst : TPtAllConst) : boolean;
begin
   Result := False;
   //    1
   if RqPtApp = nil then Exit;
   try
     if RqPtApp^.PtAllConst = nil then Exit;
     PtAllConst := RqPtApp^.PtAllConst;
     Result := True;
   except end;
end;
// ----------------------------------------------------------------
// 12.01.2020
//       .
function GetScopeSOBJ(RqPtApp : TPtApp;
                      RqIndx  : integer;
                 var  SOBJ     : TObject) : boolean;
begin
   Result := False;
   //    1
   if RqPtApp = nil then Exit;
   with RqPtApp^ do
   begin
      if (RqIndx < 0) or (RqIndx > MaxIndx) then Exit;
      try
         SOBJ := ArrSOBJ[RqIndx];
         if SOBJ <> nil then Result := True;
      except end;
   end;
end;
// ----------------------------------------------------------------
// 12.01.2020
//      
//   .
function GetScopeDescSobj(RqPtApp : TPtApp;
                          RqIndx  : integer;
                     var  DESC    : TAppScope;
                     var  SOBJ     : TObject) : boolean;
var wPtArrDESC : ^TMaxArrDESC;
begin
   Result := False;
   //    1
   if RqPtApp = nil then Exit;
   with RqPtApp^ do
   begin
      //    2
      if PtArrDESC = nil then Exit;
      if (RqIndx < 0) or (RqIndx > MaxIndx) then Exit;
      try
         wPtArrDESC := PtArrDESC;
         DESC := wPtArrDESC^[RqIndx];
         SOBJ := ArrSOBJ[RqIndx];
         if SOBJ <> nil then Result := True;
      except end;
   end;
end;

// ================================================================
//      
// ================================================================
// ----------------------------------------------------------------
// 12.01.2020
//         
function LoadAllScopeAndSensorArr() : boolean;
var wAppCount : integer;    //  .
    wAppInd   : integer;    //  
    wPtApp    : TPtApp;     //   .
    wAppName  : string;     //  .
    wSenCount : integer;    //    .
    DESC      : TAppScope;  //    .
    Ind       : integer;    //  
begin
   // -------------------
   //  
   Result := False;
   // -------------------
   //  
   //     
   if not LoadAllPtScopeArr() then Exit;
   // -------------------
   try
      //     
      wAppCount := Length(AllPtScopeArr);
      SetLength(AllSensorArr,wAppCount);
      // -------------------
      //   .
      for wAppInd := Low(AllPtScopeArr) to High(AllPtScopeArr)
      do begin
          // -------------------
          //    .
          wPtApp := AllPtScopeArr[wAppInd];
          if wPtApp <> nil
          then begin
            // -------------------
            //  
            wAppName := wPtApp^.PtAllConst^.AppName;
            AllSensorArr[wAppInd].AppName := wAppName;
            // -------------------
            // ,  
            //     
            //   .
            // -------------------
            wSenCount := Length(wPtApp.ArrSOBJ);
            SetLength(AllSensorArr[wAppInd].AppSensorArr, wSenCount);
            // -------------------
            //   
            for Ind := Low(wPtApp.ArrSOBJ) to High(wPtApp.ArrSOBJ)
            do begin
               with AllSensorArr[wAppInd].AppSensorArr[Ind] do
               begin
                 if GetScopeDESC(wPtApp, Ind, DESC)
                 then begin
                    Title := DESC.Title;  //  
                    Min   := DESC.Min;    //    
                    Max   := DESC.Max;    //    
                    Value := DESC.Value;  //    
                    //  
                    SampInd := -1;        //    
                    SetLength(SampArr,0); //   
                 end
                 else begin
                    Title := '';          //  
                    Min   := 0;           //    
                    Max   := 0;           //    
                    Value := 0;           //    
                    //  
                    SampInd := -1;        //    
                    SetLength(SampArr,0); //   
                 end;
               end;
            end; // for Ind
            // -------------------
          end
          else begin
              // .  
              AllSensorArr[wAppInd].AppName := '';
              SetLength(AllSensorArr[wAppInd].AppSensorArr, 0);
          end;
      end;  // for wAppInd
      // -------------------
      Result := True;
   // -------------------
   except
      MessageDlg('CommonSRV03.LoadAllScopeAndSensorArr ERROR :'
       + #13#10 + '     ',
                  mtError, [mbOk], 0);
   end;
   // -------------------
end;

// =========================================================================
//       
// =========================================================================
// 12.01.2020
//    
function StartMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   Result := '';
   try
       RqStamp.BTime := timeGetTime;
       RqStamp.MMErr := 0;
   except
       RqStamp.MMErr := 1;          //   
       Result := '.';
   end;
end;
// -------------------------------------------------------------------------
// 12.01.2020
//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   if RqStamp.MMErr = 0
   then begin
      with RqStamp
      do begin
          try
            ETime := timeGetTime;
            if (ETime - BTime) >= 0
            then Result := IntToStr(ETime - BTime);
          except
            MMErr := 1;
            Result := '.';
          end;
      end;
   end;
end;

// ================================================================
// 
// ================================================================


end.
